#version 430 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec2 texCoords;

layout (location = 0) out vec3 fragPosition;
layout (location = 1) out vec3 noiseCoords;
layout (location = 2) out vec3 fragNormal;
layout (location = 3) out vec2 staticNoiseCoords;

uniform mat4 VP;
uniform mat4 view;
uniform mat4 model;
uniform mat4 worldMatrix;

uniform float cloudHeight;

uniform vec3 cameraPosition;


void main()
{

  vec4 pos = model * vec4(position * cloudHeight, 1.0);

  gl_Position =  VP * pos;

  noiseCoords = normalize(position);

  fragPosition = (worldMatrix * vec4(position * cloudHeight, 1.0)).xyz;

  staticNoiseCoords = texCoords;
}